#!/usr/bin/env python3
import os, time
FITS = "data/KiDS_DR4.1_ugriZYJHKs_SOM_gold_WL_cat.fits"

# find the running lens pre-stack PID
pids = [p for p in os.popen("pgrep -f 'prestack_kids.py .*lenses.csv'").read().split() if p.strip()]
if not pids:
    print("No running prestack_kids.py for lenses.csv found."); raise SystemExit(0)
pid = int(pids[0])

size = os.stat(FITS).st_size
fd = None
for ent in os.listdir(f"/proc/{pid}/fd"):
    try:
        link = os.readlink(f"/proc/{pid}/fd/{ent}")
        if FITS.split('/')[-1] in link:
            fd = ent; break
    except OSError:
        pass
if fd is None:
    print("Could not locate FITS fd in process."); raise SystemExit(1)

while True:
    with open(f"/proc/{pid}/fdinfo/{fd}") as f:
        for line in f:
            if line.startswith("pos:"):
                pos = int(line.split()[1]); break
    pct = 100.0 * pos / size
    print(f"KiDS catalog read ~{pct:5.1f}%  (PID {pid}, fd {fd})")
    time.sleep(5)
